// PageSettingSipEx.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingSipEx.h"


// CPageSettingSipEx dialog

IMPLEMENT_DYNAMIC(CPageSettingSipEx, CDialog)

CPageSettingSipEx::CPageSettingSipEx(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSettingSipEx::IDD, pParent)
	, m_csChannelID(_T(""))
	, m_iLevel(0)
	, m_iPtzTime(0)
{

}

CPageSettingSipEx::~CPageSettingSipEx()
{
}

void CPageSettingSipEx::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_CHANNEL, m_cboChannel);
	DDX_Control(pDX, IDC_COMBO_PICNO, m_cboPic);
	DDX_Text(pDX, IDC_EDIT_CHANNELID, m_csChannelID);
	DDV_MaxChars(pDX, m_csChannelID, 32);
	DDX_Text(pDX, IDC_EDIT_LEVEL, m_iLevel);
	DDX_Text(pDX, IDC_EDIT_LEVEL2, m_iPtzTime);
	DDX_Control(pDX, IDC_COMBO_CONNECTMODE, m_cboMode);
	DDX_Control(pDX, IDC_COMBO_CONTYPE, m_cboType);
}


BEGIN_MESSAGE_MAP(CPageSettingSipEx, CDialog)
	ON_CBN_SELCHANGE(IDC_COMBO_CHANNEL, &CPageSettingSipEx::OnCbnSelchangeComboChannel)
	ON_CBN_SELCHANGE(IDC_COMBO_PICNO, &CPageSettingSipEx::OnCbnSelchangeComboPicno)
	ON_BN_CLICKED(IDC_BUTTON_SETSIP, &CPageSettingSipEx::OnBnClickedButtonSetsip)
END_MESSAGE_MAP()


// CPageSettingSipEx message handlers
int   CPageSettingSipEx::Initialize()
{
	LoadSurfaceResource();

	CreateChannelCombo(m_lLogonID, &m_cboChannel);
	OnCbnSelchangeComboChannel();
	UpdateSipChannel();

	return ERR_SUCCESS;
}

void CPageSettingSipEx::OnParamChangeNotify(_CHANGE_PARAM_NOTIFY_DATA* pData)
{
	switch(pData->m_iMsg)
	{
	case DEC_PARACHANGE_FLOAT_WINDOW:
		{
			UpdateSipChannel();
		}
		break;
	}
}


void  CPageSettingSipEx::LoadSurfaceResource()
{
	SetDlgItemText(IDC_STATIC_CHANNEL, GetTextByLan("ͨ","Channel No"));
	SetDlgItemText(IDC_STATIC_PICNO, GetTextByLan("","Pic No"));
	SetDlgItemText(IDC_STATIC_CHANNELID, GetTextByLan("ͨID","Channel ID"));
	SetDlgItemText(IDC_STATIC_LEVEL, GetTextByLan("ȼ","Pic No"));
	SetDlgItemText(IDC_STATIC_PTZTIME, GetTextByLan("PTZʱ","PTZ Ctrl Time"));
	SetDlgItemText(IDC_STATIC_CONNECTMODE, GetTextByLan("ģʽ","Connect Mode"));
	SetDlgItemText(IDC_STATIC_CONTYPE, GetTextByLan("","Connect Type"));
	SetDlgItemText(IDC_BUTTON_SETSIP, GetTextByLan("","Set"));
}
void CPageSettingSipEx::OnCbnSelchangeComboChannel()
{
	// TODO: Add your control notification handler code here
	CreatePosCombo(m_lLogonID,GetComboData(&m_cboChannel),0, &m_cboPic,POS_WITH_WIN);
	UpdateSipChannel();
}

void CPageSettingSipEx::OnCbnSelchangeComboPicno()
{
	// TODO: Add your control notification handler code here
	UpdateSipChannel();
}

void CPageSettingSipEx::UpdateSipChannel()
{
	SipVideoChannelEx tSipVideoChannelEx = {0};
	int iRet = DEC_ClientGetDevConfig(m_lLogonID,GetComboData(&m_cboChannel),GetComboData(&m_cboPic),CMD_DEC_CFG_SIP_VIDEO_CHANNEL_EX_V2,\
		&tSipVideoChannelEx,sizeof(SipVideoChannelEx));
	if(ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CPageSettingSipEx::UpdateSipChannel] DEC_ClientGetDevConfig Failed! \
								Ret(%d),CMDID(CMD_DEC_CFG_SIP_VIDEO_CHANNEL_EX_V2)",iRet);
		return;
	}

	m_iLevel = tSipVideoChannelEx.iLevel;
	m_csChannelID = tSipVideoChannelEx.cChannelID;
	m_iPtzTime = tSipVideoChannelEx.iPtzTime;
	m_cboMode.SetCurSel(tSipVideoChannelEx.iConnectMode);
	m_cboType.SetCurSel(tSipVideoChannelEx.iTCPConnectType);

	UpdateData(FALSE);
}
void CPageSettingSipEx::OnBnClickedButtonSetsip()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	SipVideoChannelEx tSipVideoChannelEx= {0};
	strcpy_s(tSipVideoChannelEx.cChannelID,sizeof(tSipVideoChannelEx.cChannelID),m_csChannelID.GetBuffer(0));
	tSipVideoChannelEx.iLevel = m_iLevel;
	tSipVideoChannelEx.iPtzTime = m_iPtzTime;
	tSipVideoChannelEx.iConnectMode = m_cboMode.GetCurSel();
	tSipVideoChannelEx.iTCPConnectType = m_cboType.GetCurSel();

	int iRet = DEC_ClientSetDevConfig(m_lLogonID,GetComboData(&m_cboChannel),GetComboData(&m_cboPic),\
		CMD_DEC_CFG_SIP_VIDEO_CHANNEL_EX_V2,&tSipVideoChannelEx,sizeof(SipVideoChannelEx));
	if(ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CPageSettingSipEx::OnBnClickedButtonSetsip] DEC_ClientSetDevConfig Failed! \
								Ret(%d),CMDID(CMD_DEC_CFG_SIP_VIDEO_CHANNEL_EX_V2)",iRet);
	}

}
